/* bittest.c
 * tests bit-map routines
 */

#include<stdio.h>
#include<mem.h>
#include"PcMag.h"                        /* standard definitions    */

#define BITMAP_SIZE 1024
#define NUM_BITS    8
#define MAXVAL   (BITMAP_SIZE*NUM_BITS)
#define Bmap_init(bitmap,size)   memset(bitmap,0,size)

unsigned char bitmap[BITMAP_SIZE];       /* can track 8000 elements */

main()
{
    int n,i;
    char    linebuffer[100];

    Bmap_init(bitmap,BITMAP_SIZE);      /* initialize the bitmap to 0   */

    while(TRUE)
    {
        printf("\nEnter a number to put in the list & <RETURN> (^Z to go on):\n");
        if(!gets(linebuffer))
            break;
        i = atoi(linebuffer);
        if(i < 0 || i > MAXVAL)
            printf("\nOnly numbers from 0 to %d are valid in this demo",MAXVAL);
        else
            setbit(bitmap,i);
    }

    while(TRUE)
    {
        printf("\nEnter a number to EXCLUDE from the list & <RETURN> (^Z to go on):\n");
        if(!gets(linebuffer))
            break;
        i = atoi(linebuffer);
        if(i < 0 || i > MAXVAL)
            printf("\nOnly numbers from 0 to %d are valid in this demo",MAXVAL);
        else
            resetbit(bitmap,i);
    }

    printf("\nThe included numbers are:\n");

    for(i = n = 0; i < MAXVAL; i++)
        if(isbitset(bitmap,i))      {
            n++;
            printf("%3d %c",i, ((n % 13) ? ' ' : '\n') );
        }
    printf("\nThat\'s it");
}

    /* setbit() - turns ON bit n in bitmap      */
setbit(bitmap,n)    
char    *bitmap;
int     n;
{
    bitmap[n/8] |= (1 << (n % 8));
}

    /* unsetbit()  - turns OFF bit n in bitmap  */
resetbit(bitmap,n)
char    *bitmap;
int     n;
{
    bitmap[n/8] &= (~(1 << (n % 8)));
}

/* isbitset() - returns TRUE if bit n is ON in bitmap, else returns FALSE */

isbitset(bitmap,n)
char    *bitmap;
int     n;
{
    return (bitmap[n/8] & (1 << (n%8)));
}

    /* End of Btest.c ****************************/
